#ifndef DDIALOGOABRIR_H
    #define DDIALOGOABRIR_H

    #include "DString.h"
    #include <vector>

    namespace DWL {

		//! Clase para mostrar un dialogo abrir del sistema
		class DDialogoAbrir {
	  	  public : /////////////////////////// Miembros publicos

											//! Constructor.
											/*!	Constructor por defecto.
													\fn		DDialogoAbrir(void);
													\return	No devuelve nada.
											*/
											DDialogoAbrir(void) { 
											};

											//! Constructor que muestra el dilogo.
											/*!	Constructor que muestra el dilogo directamente segn los parametros especificados.
													\fn			DDialogoAbrir(const TCHAR *PathSh, const TCHAR *Filtro, const TCHAR *Titulo, const bool MultiSeleccion = true, HWND hWndPadre = NULL);
													\param[in]	PathSh			: Ruta inicial desde donde empezara el dialogo abrir
													\param[in]  Filtro			: Filtro de archivos
													\param[in]  Titulo			: Titulo del dialogo
													\param[in]  MultiSeleccion	: Habilitar multiseleccin
													\param[in]  hWndPadre		: Ventana padre, puede ser NULL. Si especificamos una ventana padre, esta se desactivara mientras el dialogo este activo.
													\return		No devuelve nada.
													\remarks    Filtro debera estar formateado de la siguiente forma :\n
																\code Todos los archivos\0*.*\0\0 \endcode

																Observad que primero hay un string con el nombre del filtro, luego el tipo de filtro, y por ultimo termina con un doble caracter <b>\\0</b>. \n\n
																Si por ejemplo queremos tener un filtro para documentos de texto debemos construirlo de una forma similar a este : \n
																\code Todos los archivos\0*.*\0Documentos de texto\0*.doc;*.txt;*.rtf\0\0 \endcode
																Observad que esta vez hemos aadido 3 tipos de archivo para el filtro Documentos de texto, esos tipos de archivo deben estar separados por el caracter <b>;</b>
											*/
											DDialogoAbrir(const TCHAR *PathSh, const TCHAR *Filtro, const TCHAR *Titulo, const bool MultiSeleccion = true, HWND hWndPadre = NULL) { 
						 						MostrarAbrir(PathSh, Filtro, Titulo, MultiSeleccion, hWndPadre); 
											};

											//! Funcin que muestra el dilogo para abrir archivos.
											/*!	Funcin que muestra el dilogo para abrir archivos segn los parametros especificados.
													\fn			UINT MostrarAbrir(const TCHAR *PathSh, const TCHAR *Filtro, const TCHAR *Titulo, const bool MultiSeleccion = true, HWND hWndPadre = NULL) {
													\param[in]	PathSh			: Ruta inicial desde donde empezara el dialogo abrir
													\param[in]  Filtro			: Filtro de archivos
													\param[in]  Titulo			: Titulo del dialogo
													\param[in]  MultiSeleccion	: Habilitar multiseleccin
													\param[in]  hWndPadre		: Ventana padre, puede ser NULL. Si especificamos una ventana padre, esta se desactivara mientras el dialogo este activo.
													\return		Devuelve el numero de archivos seleccionados.
													\remarks    Filtro debera estar formateado de la siguiente forma :\n
																\code Todos los archivos\0*.*\0\0 \endcode
																Observad que primero hay un string con el nombre del filtro, luego el tipo de filtro, y por ultimo termina con un doble caracter <b>\\0</b>. \n\n
																Si por ejemplo queremos tener un filtro para documentos de texto debemos construirlo de una forma similar a este : \n
																\code Todos los archivos\0*.*\0Documentos de texto\0*.doc;*.txt;*.rtf\0\0 \endcode
																Observad que esta vez hemos aadido 3 tipos de archivo para el filtro Documentos de texto, esos tipos de archivo deben estar separados por el caracter <b>;</b>
											*/
		    UINT							MostrarAbrir(const TCHAR *PathSh, const TCHAR *Filtro, const TCHAR *Titulo, const bool MultiSeleccion = true, HWND hWndPadre = NULL); 

											//! Funcin que devuelve el total de archivos seleccionados
											/*!	Esta funcion devuelve el total de archivos seleccionados.
													\fn		inline UINT TotalArchivos(void);
													\return	Devuelve el total de archivos seleccionados.
													\sa		Archivos(), operator [].
											*/
			inline UINT						TotalArchivos(void) {
												return static_cast<UINT>(_Archivos.size());
											}

											//! Funcin que devuelve la ruta del archivo especificado
											/*!	Esta funcion devuelve la ruta del archivo especificado en el parametro Pos
													\fn			inline const TCHAR *Archivos(const int Pos)
													\param[in]	Pos : Posicin en el array de archivos seleccionados
													\return		Devuelve una cadena de caracteres con la ruta del archivo.
													\sa			TotalArchivos().
											*/
			inline const TCHAR             *Archivos(const int Pos) { 
												return _Archivos[Pos].Texto(); 
											};

											//! Operador que devuelve la ruta del archivo especificado
											/*!	Esta operador devuelve la ruta del archivo especificado en el parametro Pos
													\fn			inline const TCHAR *operator [] (const int Pos);
													\param[in]	Pos : Posicin en el array de archivos seleccionados
													\return		Devuelve una cadena de caracteres con la ruta del archivo.
													\sa			TotalArchivos().
											*/
			inline const TCHAR        	   *operator [] (const int Pos) { 
												return _Archivos[Pos].Texto(); 
											};

		  private : ////////////////////////// Miembros privados
											
											//! Vector de archivos seleccionados con las rutas completas
			std::vector<DString>           _Archivos;
		};


    };

#endif